# -*- coding: utf-8 -*-
"""
Created on Fri Jan  7 15:43:56 2022

@author: pwiechen
"""
#%%
import numpy as np   
import pandas as pd            
import matplotlib.pyplot as plt 
import os
from datetime import datetime, timedelta
import scipy.signal
import calendar
from matplotlib import cm

%matplotlib qt 

dir_path = os.path.dirname(os.path.abspath(__file__))
os.chdir(dir_path)

print(dir_path)


def toTimestamp(d):
  return calendar.timegm(d.timetuple())

#%% Load Rijkswaterstaat Data

# Water levels at Scheveningen and Hoek van Holland

eta_raw = pd.read_csv(r'20220107_059.csv',encoding = 'unicode_escape',header=0, delimiter =';', usecols=[2,6,21,22,24,26,46], index_col=False, decimal=",",low_memory=False)
eta_raw['Time'] = pd.to_datetime(eta_raw['WAARNEMINGDATUM'] + ' ' + eta_raw['WAARNEMINGTIJD (MET/CET)'], format='%d-%m-%Y %H:%M:%S')
eta_raw['NUMERIEKEWAARDE'] = eta_raw['NUMERIEKEWAARDE']*0.01

eta_hoek_act = eta_raw[(eta_raw['LOCATIE_CODE']=='HOEK') & (eta_raw['GROOTHEID_ CODE']=='WATHTE') & (eta_raw['KWALITEITSOORDEEL_CODE']=='Normale waarde') & (eta_raw['GROEPERING_OMSCHRIJVING'] != 'Getijextreem berekend')]
eta_hoek_act.rename(columns={"NUMERIEKEWAARDE":"eta_hoek_act", "Time":"time"}, inplace=True)

eta_hoek_ast = eta_raw[(eta_raw['LOCATIE_CODE']=='HOEKVHLD') & (eta_raw['GROOTHEID_ CODE']=='WATHTBRKD') & (eta_raw['KWALITEITSOORDEEL_CODE']=='Normale waarde') & (eta_raw['GROEPERING_OMSCHRIJVING'] != 'Getijextreem berekend')]
eta_hoek_ast.rename(columns={"NUMERIEKEWAARDE":"eta_hoek_ast", "Time":"time"}, inplace=True)

eta_sche_act = eta_raw[(eta_raw['LOCATIE_CODE']=='SCHE') & (eta_raw['GROOTHEID_ CODE']=='WATHTE') & (eta_raw['KWALITEITSOORDEEL_CODE']=='Normale waarde') & (eta_raw['GROEPERING_OMSCHRIJVING'] != 'Getijextreem berekend')]
eta_sche_act.rename(columns={"NUMERIEKEWAARDE":"eta_sche_act", "Time":"time"}, inplace=True)

eta_sche_ast = eta_raw[(eta_raw['LOCATIE_CODE']=='SCHEVNGN') & (eta_raw['GROOTHEID_ CODE']=='WATHTBRKD') & (eta_raw['KWALITEITSOORDEEL_CODE']=='Normale waarde') & (eta_raw['GROEPERING_OMSCHRIJVING'] != 'Getijextreem berekend')]
eta_sche_ast.rename(columns={"NUMERIEKEWAARDE":"eta_sche_ast", "Time":"time"}, inplace=True)

eta_dataset_1 = eta_hoek_act.merge(eta_hoek_ast, how='inner', on='time', validate='one_to_one')
eta_dataset_2 = eta_dataset_1.merge(eta_sche_act, how='inner', on='time', validate='one_to_one')
eta_dataset_temp = eta_dataset_2.merge(eta_sche_ast, how='inner', on='time', validate='one_to_one')

eta_dataset_temp = eta_dataset_temp[["time","eta_sche_ast","eta_sche_act","eta_hoek_ast","eta_hoek_act"]]

del eta_raw, eta_hoek_act, eta_hoek_ast, eta_sche_act, eta_sche_ast, eta_dataset_1, eta_dataset_2

'''
The estimate for the Sand Engine is defined as the average of the elevation at Hoek van Holland and Scheveningen. 
To correct for the phase shift of approximately 20 minutes, the Scheveningen elevation is shifted 20 minutes ahead in time.
Next, the averaging commences and the result is pushed 10 minutes forward to account for the Sand Engine phase shift. 
'''
sche_peaks = scipy.signal.find_peaks(eta_dataset_temp['eta_sche_ast'], distance = 60)[0]
hvh_peaks = scipy.signal.find_peaks(eta_dataset_temp['eta_hoek_ast'], distance = 60)[0]
phase_lag_sche_hoek = np.round(np.average(sche_peaks-hvh_peaks),decimals=0)
phase_lag_SE = np.round(np.average(sche_peaks-hvh_peaks),decimals=0)/2

sche_time_shifted = pd.DataFrame(data={
    'time': eta_dataset_temp['time'] - timedelta(minutes = phase_lag_SE*10),
    'eta_sche_ast': eta_dataset_temp['eta_sche_ast'],
    'eta_sche_act': eta_dataset_temp['eta_sche_act']})

hoek_time_shifted = pd.DataFrame(data={
    'time': eta_dataset_temp['time'] + timedelta(minutes = phase_lag_SE*10),
    'eta_hoek_ast': eta_dataset_temp['eta_hoek_ast'],
    'eta_hoek_act': eta_dataset_temp['eta_hoek_act']})

eta_se = hoek_time_shifted.merge(sche_time_shifted, how='inner', on='time', validate='one_to_one')

eta_se['eta_se_estimate_ast'] = 0.5*(eta_se['eta_hoek_ast']+eta_se['eta_sche_ast'])
eta_se['eta_se_estimate_act'] = 0.5*(eta_se['eta_hoek_act']+eta_se['eta_sche_act'])

eta_se = eta_se[["time","eta_se_estimate_ast","eta_se_estimate_act"]]

eta_dataset = eta_dataset_temp.merge(eta_se, how='inner', on='time', validate='one_to_one')

eta_dataset.to_csv(r'dataset_eta_HvH_SCHE_RWS.csv')

#%%

# Air pressure at Hoek van Holland

types_dict_ap = {'station': str,'Date': str,'Hour': float,'pressure': float}
air_pressure_raw = pd.read_csv(r'luchtdruk_HvH_Voorschoten.txt', skiprows=31, delimiter=',', skipinitialspace=True, usecols=[0,1,2,14], dtype=types_dict_ap, names=['station','Date','Hour','pressure'])
air_pressure_raw['time'] = np.zeros(len(air_pressure_raw['Date'].values))

for i in range(len(air_pressure_raw['time'])):
    air_pressure_raw['time'][i] = pd.to_datetime(air_pressure_raw['Date'].values[i], format='%Y%m%d') + timedelta(hours=air_pressure_raw['Hour'].values[i])

air_pressure_raw.drop(columns=['Date', 'Hour'], inplace=True)
air_pressure_voor = air_pressure_raw[air_pressure_raw.station.str.contains('215')]
air_pressure_voor.rename(columns={"pressure":"pressure_voorschoten"}, inplace=True)
air_pressure_voor['pressure_voorschoten'] = 10*air_pressure_voor['pressure_voorschoten'] # hPa

air_pressure_HvH = air_pressure_raw[air_pressure_raw.station.str.contains('330')]
air_pressure_HvH.rename(columns={"pressure":"pressure_HvH"}, inplace=True)
air_pressure_HvH['pressure_HvH'] = 10*air_pressure_HvH['pressure_HvH'] # hPa

air_pressure_Voor_HvH = air_pressure_voor.merge(air_pressure_HvH, how='inner', on='time', validate='one_to_one')
air_pressure_Voor_HvH = air_pressure_Voor_HvH[["time","pressure_voorschoten","pressure_HvH"]]

air_pressure_Voor_HvH['time'] = air_pressure_Voor_HvH['time'] + timedelta(seconds=3600)

del i, types_dict_ap,  air_pressure_HvH, air_pressure_voor, air_pressure_raw

air_pressure_Voor_HvH.to_csv(r'dataset_air_pressure_HvH_Voorschoten_KNMI.csv')

#%%

plt.figure()

plt.plot(air_pressure_Voor_HvH['time'], air_pressure_Voor_HvH['pressure_HvH'])

#%%